package com.ejie.aa17a.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.Aa17aBanda;
import com.ejie.aa17a.service.iface.Aa17aBandaService;

/**
 * Aa17aBandaController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/banda")
public class Aa17aBandaController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aBandaController.class);

	private Aa17aBandaService aa17aBandaService;

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aBanda
	 *            Aa17aBanda
	 * @return List
	 */
	@RequestMapping(value = "lista", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aBanda> getAll(@ModelAttribute Aa17aBanda filterAa17aBanda) {
		Aa17aBandaController.logger.info("[GET - find_ALL] : Obtener Aa17aBanda por filtro");
		return this.aa17aBandaService.findAll(filterAa17aBanda);
	}

	/**
	 * Method 'setAa17aBandaService'.
	 * 
	 * @param aa17aBandaService
	 *            Aa17aBandaService
	 * @return
	 */
	public void setAa17aBandaService(Aa17aBandaService aa17aBandaService) {
		this.aa17aBandaService = aa17aBandaService;
	}
}
